module PayoutEntities
  class ActivationPolicy < ApplicationPolicy
    def index?
      allowed?
    end

    def create?
      allowed?
    end

    def new?
      allowed?
    end

    def allowed?
      payout_entities? && can_manage_partner_status?
    end

    def payout_entities?
      user.permitted? BeefCake::Permission.for(:payout_entities)
    end

    def can_manage_partner_status?
      user.permitted? BeefCake::Permission.for(:manage_partner_status)
    end
  end
end
