module PayoutEntities
  class InvitationPolicy < ApplicationPolicy
    def index?
      allowed?
    end

    def create?
      allowed?
    end

    def new?
      allowed?
    end

    def destroy?
      allowed?
    end

    def remove?
      allowed?
    end

    def allowed?
      PayoutEntities::Invitation::AVAILABLE_CATEGORIES_AND_PERMISSIONS.each do |_, permission|
        if user.permitted? BeefCake::Permission.for(permission)
          return true
        end
      end

      return false
    end
  end
end
