module ResqueJobs
  class JobPolicy < ApplicationPolicy
    def index?
      read_allowed?
    end

    def show?
      read_allowed?
    end

    def destroy?
      allowed?
    end

    def kill?
      allowed?
    end

    def delete_all?
      allowed?
    end

    def delete_completed?
      allowed?
    end

    def delete_failed?
      allowed?
    end

    def read_allowed?
      [
        :support_tools,
        :vods
      ].any? { |perm| user.permitted? BeefCake::Permission.for(perm) }
    end

    def allowed?
      user.permitted? BeefCake::Permission.for(:support_tools)
    end
  end
end
