module Twitch
  class TeamMembershipPolicy < ApplicationPolicy
    def index?
      true
    end

    def create?
      manage_twitch_team_memberships?
    end

    def destroy?
      manage_twitch_team_memberships?
    end

    private

    def manage_twitch_team_memberships?
      user.permitted? BeefCake::Permission.for(:manage_twitch_teams)
    end
  end
end
