module Twitch
  class TeamPolicy < ApplicationPolicy
    def index?
      allowed?
    end

    def show?
      allowed?
    end

    def new?
      manage_twitch_teams?
    end

    def create?
      manage_twitch_teams?
    end

    def edit?
      manage_twitch_teams?
    end

    def update?
      manage_twitch_teams?
    end

    def delete?
      manage_twitch_teams?
    end

    def destroy?
      manage_twitch_teams?
    end

    def search?
      allowed?
    end

    def allowed?
      true
    end

    private

    def manage_twitch_teams?
      user.permitted? BeefCake::Permission.for(:manage_twitch_teams)
    end
  end
end
