module Twitch
  class UserChannelPropertyPolicy < ApplicationPolicy
    def edit?
      allowed?
    end

    def update?
      allowed?
    end

    def regenerate_stream_key?
      allowed?
    end

    def remove_authorized_stream_key?
      allowed?
    end

    def add_authorized_stream_key?
      allowed?
    end

    def disconnect?
      allowed?
    end

    def allowed?
      [
        BeefCake::Permission.for(:users),
        'twitch_user:update_channel_properties'
      ].any? { |p| user.permitted_on_twitch_user?(p, @record.user) }
    end
  end
end
