module BannedWords
  class Item < BannedWords::Base
    SERVICE_PATH = "global/banned_words"

    attributes :word
    self.primary_attribute = :word

    def self.all(options = {})
      response = get SERVICE_PATH, params: options

      response.body['banned_words'].map do |banned_word_attributes|
        from_attributes(banned_word_attributes)
      end
    end

    def save
      response = put SERVICE_PATH, body: attributes.to_json
      response.success?
    end

    def destroy
      response = delete SERVICE_PATH, body: attributes.to_json
      response.success?
    end
  end
end
