require "twitch_s2s2"

module BeefCake
  class Base < Service::Base
    include ActiveModel::Serialization

    PER_PAGE = 10
    self.service_endpoint = Settings.beefcake.endpoint
    self.primary_attribute = :id

    def ==(other)
      serializable_hash == other.serializable_hash
    end

    def self.client
      @client ||= Twitch::Fulton::Beefcake::TwitchBeefcakeClient.new(
        connection(additional_middleware: [s2s2_middleware])
      )
    end

    def self.twirp_data(res)
      handle_error(res)
      res.data
    end

    def self.handle_error(res)
      raise res.error.msg if res.error
    end

    protected

    def client
      self.class.client
    end

    def handle_error(res)
      self.class.handle_error(res)
    end

    def twirp_data(res)
      self.class.twirp_data(res)
    end
  end
end
