module BeefCake
  class Realm < BeefCake::Base
    attributes :id, :name

    class InvalidRealm < StandardError; end

    TWITCH_LDAP = from_attributes(id: '', name: 'Twitch LDAP').freeze
    TITAN_SUPPORT = from_attributes(id: 'titan', name: 'Titan').freeze
    REALMS = [TWITCH_LDAP, TITAN_SUPPORT].freeze
    BY_ID = REALMS.each_with_object({}) { |r, m| m[r.id] = r }.freeze

    def self.all
      REALMS
    end

    def self.find(id)
      BY_ID[id]
    end
  end
end
