module Bits
  class Actual < Service::Base
    include Code::Justin::Tv::Commerce::Pachter
    include Google::Protobuf

    self.service_endpoint = Settings.pachter.endpoint
    self.primary_attribute = :id

    attributes :id, :amount
    validates :id, :amount, presence: true

    def self.twirp_client
      @twirp_client ||= PachterClient.new(connection)
    end

    def self.all(month, year, platform)
      resp = twirp_client.get_actuals(GetActualsReq.new(month: month, year: year, platform: platform))
      raise resp.error.msg if resp.error

      resp.data.actuals.to_h.sort
    end

    def self.platforms
      platforms = Platform.constants.reject { |p| p == :NONE }
      platforms.map(&:to_s)
    end

    def self.configure(month, year, platform, actuals_to_update)
      resp = twirp_client.set_actuals(SetActualsReq.new(month: month, year: year, platform: platform, actuals: actuals_to_update))
      raise resp.error.msg if resp.error
      true
    end

  end
end