module Bits
  class Badge < Bits::Base
    def self.all(user_id)
      bits_badge_tiers_response = get "/authed/admin/badges/#{user_id}/tiers"
      return from_errors('Failed to load bits badge tiers') unless bits_badge_tiers_response.success?

      bits_badge_tiers_response.body['tiers'].sort_by { |t| t['threshold'] }
    end

    def self.update_badge_tiers(user_id, tiers)
      body = JSON.dump({
        tiers: tiers,
      })

      response = patch(
        "/authed/admin/badges/#{user_id}/tiers",
        body: body
      )

      response.success?
    end
  end
end
