module Bits
  class Job < Bits::Base

    attributes :creator, :job_id, :bits_amount, :annotation, :input_users, :user_logins, :user_ids, :campaign_id, :by

    def self.all(creator)
      resp = get "/authed/admin/jobs?creator=#{creator}"
      jobs = resp.body['admin_jobs']
      jobs.each{ |job|
        job['can_get_output'] = false
        if job['progress'] >= 1
          job['can_get_output'] = true if job['num_output_files'].positive?
        end
      }
      jobs
    end

    def start_bulk_entitle_job
      body = JSON.dump(
          creator: self.creator,
          job_id: SecureRandom.uuid + '-' + self.annotation,
          bits_amount: self.bits_amount.to_i,
          admin_reason: self.annotation,
          recipient_logins: self.user_logins,
          recipient_ids: self.user_ids
      )
      post(
        "/authed/admin/jobs/bulk-entitle",
        body: body
      )
    end

    def start_bulk_entitle_by_campaign_job
      body = JSON.dump(
          creator: self.creator,
          job_id: SecureRandom.uuid,
          bulk_grant_campaign_id: self.campaign_id,
          recipient_logins: self.user_logins,
          recipient_ids: self.user_ids
      )
      post(
        "/authed/admin/jobs/bulk-entitle",
        body: body
      )
    end

    def get_input(creator, job_id)
      get "/authed/admin/job/input?creator=#{creator}&job_id=#{job_id}"
    end

    def get_options(creator, job_id)
      get "/authed/admin/job/options?creator=#{creator}&job_id=#{job_id}"
    end

    def get_output(creator, job_id)
      get "/authed/admin/job/output?creator=#{creator}&job_id=#{job_id}"
    end
  end
end
