module Clue
  class ChatProperty < Clue::Base
    self.primary_attribute = :id

    attributes :id,
        :chat_rules,
        :chat_require_verified_account,
        :hide_chat_links,
        :rituals_whitelisted,
        :rituals_enabled,
        :r9k_only_chat,
        :subscribers_only_chat,
        :chat_fastsubs,
        :followers_only_duration

    def self.find(id)
      return [] if id.blank?

      response = get("/rooms/#{id}")

      if response.success?
        from_attributes(response.body["room"])
      else
        return []
      end
    end

    def update(params)
      options = {
        chat_require_verified_account: params[:chat_require_verified_account],
        hide_chat_links: params[:hide_chat_links],
        rituals_enabled: params[:rituals_enabled],
        r9k_only_chat: params[:r9k_only_chat],
        subscribers_only_chat: params[:subscribers_only_chat],
        chat_fastsubs: params[:chat_fastsubs],
        followers_only_duration: params[:followers_only_duration],
      }

      response = put "/rooms/#{params[:id]}", {
        body: options.to_json,
        headers: {"content-type" => "application/json"}
      }

      unless response.success?
        errors.add(:base, response.body["error"])
      end

      response
    end

  end
end
