module Connections
  BLIZZARD ||= 'blizzard'.freeze
  FACEBOOK ||= 'facebook'.freeze
  TWITTER ||= 'twitter'.freeze
  YOUTUBE ||= 'youtube'.freeze
  STEAM ||= 'steam'.freeze
  LEAGUE ||= 'league'.freeze
  PLATFORMS ||= [BLIZZARD, FACEBOOK, TWITTER, YOUTUBE, STEAM, LEAGUE].freeze

  class Connection < Connections::Base
    def self.destroy(user_id, platform)
      delete("/admin/v2/#{platform}?user_id=#{user_id}")
    end

    def self.get_all(user_id)
      PLATFORMS.inject({}) do |user_connections, platform|
        result = get("/v2/#{user_id}/#{platform}")

        has_connection = case result.status
                         when 200 then true
                         when 404 then false
                         else nil
        end

        user_connections.merge(platform => PlatformConnections::ConnectionResponse.new(has_connection, result.body))
      end
    end

    def self.query(id, platform)
      payload = {ids: [id]}
      response = post("/v2/#{platform}", {
        body: payload.to_json,
        headers: {'content-type' => 'application/json'}
      })

      if response.success?
        connected = response.body['connected']
        unless connected.nil?
          account = connected.first
          if account.present?
            account['twitch_id']
          end
        end
      end
    end
  end
end
