module ContentTag
  class Base < Service::Base
    self.service_endpoint = Settings.graffiti.endpoint

    def self.connection_options(options = {})
      options[:request] = :url_encoded
      return super(options)
    end

    def self.connection(options = {})
      super(options).tap do |c|
        c.response :json, :content_type => /\bjson$/
      end
    end
  end
end
