module DartReceiver
  class Notification < DartReceiver::Base
    include Receiver

    def self.publish_notification_to_email_address_with_locale(notification_type, email, locale, metadata)
      response = client.publish_notification(
        PublishNotificationRequest.new(
          notification_type: notification_type,
          recipient_email_address_with_locale: RecipientEmailAddressWithLocale.new(email: email, locale: locale),
          metadata: metadata
        )
      )

      raise response.error.msg if response.error
    end
  end
end
