module Dmca
  class User < Dmca::Base
    attributes :user_id, :company, :phone_number, :address, :email

    self.primary_attribute = :user_id

    def self.all
      raise "Dmca::User#all is not supported"
    end

    def self.find(user_id)
      resp = User.client.get_user(UserID: user_id)

      if resp.error
        raise resp.error.msg
      else
        user_resp = resp.data

        return User.new(user_id: user_resp.UserID,
                        company: user_resp.CompanyName,
                        phone_number: user_resp.PhoneNumber,
                        address: user_resp.Address,
                        email: user_resp.Email)
      end
    end

    def save
      resp = User.client.add_user(UserID: user_id, CompanyName: company, Address: address, PhoneNumber: phone_number, Email: email)

      if resp.error
        self.errors = [resp.error.msg]
        return
      end

      return resp.data.Success
    end

    def destroy
      resp = User.client.remove_user(UserID: user_id)

      if resp.error
        self.errors = [resp.error.msg]
        return
      end

      return resp.data.Success
    end
  end
end
