module Drops
  class Developer < Drops::Base
    self.primary_attribute = :id

    attributes :id, :name, :client_id

    def self.all(options = {})
      response = get "/admin"

      developers = Nokogiri::HTML(response.body).css('select[name="service"] option').reduce({}) { |hash, attrs|
        hash[attrs['value']] = from_attributes({
          id: attrs['value'],
          name: attrs.content,
          client_id: "",
        })
        hash
      }

      developers.values.sort_by { |a| a.name }
    end

    def self.find(id, options = {})
      response = get "/service/#{id}"

      if response.success?
        from_attributes({
          id: id,
          name: response.body["ReadableName"],
          client_id: response.body["ClientID"],
        })
      else
        from_errors(response.body["message"] || "unknown error")
      end
    end
  end
end
