module Games
  class AddAlias < Games::Base
    
    self.primary_attribute = :alias
    attributes :name, :alias
    validates :name, :alias, presence: true

    def save
      return false unless valid?

      response = put "/add_alias?alias=#{primary_attribute_value}&name=#{name}"

      self.errors.add(:base, response.body["error"]) unless response.success?

      response.success?
    end
  end
end
