module Games
  class AddCategory < Games::TwitchCategoryIndexerBase
    attributes :igdb_id

    def save
      raise "IGDB ID must not be blank" unless valid?

      request = Twitchcategoryindexer::SyncIGDBCategoryRequest.new(
        igdb_id: igdb_id
      )

      response = self.class.twirp_client.sync_i_g_d_b_category(request)

      if response.error
        raise response.error.msg
      end

      response.data
    end
  end
end

