module Games
  class AddLocalization < Games::Base

    attributes :name, :localization, :language

    validates :name, :localization, :language, presence: true

    def save
      return false unless valid?

      response = put "/localizations?locale=#{language}&game_name=#{name}&localized_name=#{localization}"

      self.errors.add(:base, response.body["error"]) unless response.success?

      response.success?
    end
  end
end
