module Graffiti
  LOCALES ||= [
    :en_us,
    :bg_bg,
    :cs_cz,
    :da_dk,
    :de_de,
    :el_gr,
    :es_es,
    :es_mx,
    :fi_fi,
    :fr_fr,
    :hu_hu,
    :it_it,
    :ja_jp,
    :ko_kr,
    :nl_nl,
    :no_no,
    :pl_pl,
    :pt_br,
    :pt_pt,
    :ro_ro,
    :ru_ru,
    :sk_sk,
    :sv_se,
    :th_th,
    :tr_tr,
    :vi_vn,
    :zh_cn,
    :zh_tw
  ]

  DESCRIPTION_LOCALES ||= [
    :description_en_us,
    :description_bg_bg,
    :description_cs_cz,
    :description_da_dk,
    :description_de_de,
    :description_el_gr,
    :description_es_es,
    :description_es_mx,
    :description_fi_fi,
    :description_fr_fr,
    :description_hu_hu,
    :description_it_it,
    :description_ja_jp,
    :description_ko_kr,
    :description_nl_nl,
    :description_no_no,
    :description_pl_pl,
    :description_pt_br,
    :description_pt_pt,
    :description_ro_ro,
    :description_ru_ru,
    :description_sk_sk,
    :description_sv_se,
    :description_th_th,
    :description_tr_tr,
    :description_vi_vn,
    :description_zh_cn,
    :description_zh_tw
  ]

  class Base < Service::Base
    self.service_endpoint = Settings.graffiti.endpoint

    def self.connection_options(options = {})
      options[:request] = :url_encoded
      return super(options)
    end

    def self.connection(options = {})
      super(options).tap do |c|
        c.response :json, :content_type => /\bjson$/
      end
    end
  end
end
