module Guardian
  class User < Guardian::Base
    self.service_endpoint = Settings.guardian.endpoint
    self.primary_attribute = :ldap_login

    attributes :ldap_login, :name, :email

    def self.all(options = {})
      response = get "/ldap/users"

      return [] unless response.success?

      response.body["data"].map do |user_attributes|
        ldap_login = user_attributes["attributes"]["uid"]
        name = user_attributes["attributes"]["cn"]
        email = user_attributes["attributes"]["email"]
        from_attributes(ldap_login: ldap_login, name: name, email: email)
      end
    end

    def self.find(uid, options = {})
      return nil unless uid

      response = get "/ldap/users/#{uid}"
      return nil unless response.success?

      user_attributes = response.body["data"]
      return nil if user_attributes.blank?

      ldap_login = user_attributes["attributes"]["uid"]
      name = user_attributes["attributes"]["cn"]
      email = user_attributes["attributes"]["email"]
      from_attributes(ldap_login: ldap_login, name: name, email: email)
    end

  end
end
