# module History contains service calls
# to the auditor
module History
  class Base < Service::Base
    PER_PAGE = 25
    MAX_PAGE = 400

    def self.service_endpoint
      return Settings.history.endpoint + '/v1/authed/audits'
    end

    def self.connection(options = {})
      super(options).tap do |conn|
        conn.response :json, :content_type => /\bjson$/
      end
    end

    def self.client
      @client ||= History::Client.new(
        'connection' => self.connection,
        'endpoint' => self.service_endpoint
      )
      @client
    end
  end
end
