module History
  class Deletion < GDPRBase
    attributes :user_id, :requester, :deletion_time

    def self.request_deletion(user_id, requester, deletion_time)
      resp = gdpr_client.delete_audits(
        user_id: user_id,
        requester: requester,
        deletion_time: deletion_time
      )
      raise resp.error if resp.error
      return resp
    end

    def self.list_scheduled_deletions(params)
      resp = gdpr_client.list_scheduled_deletes(
        requester: params.fetch(:requester, "")
      )

      raise resp.error if resp.error

      data_items = []
      unless resp.data.blank?
        data_items = resp.data.items
      end

      return {
        :items => data_items.map {|x| from_twirp_object(x)},
      }
    end

    def self.get_user_stats(user_id)
      resp = gdpr_client.get_user_stats(
        user_id: user_id
      )

      raise resp.error if resp.error
      return {
        :data => resp.data.recordCount,
      }
    end
  end
end
