require 'history/constants'

module History
  class ImpersonateUserAudit
    def initialize(admin_id:, user_id:, ip_address:, ticket_id:, reason:)
      @admin_id = admin_id
      @user_id = user_id
      @ip = ip_address
      @ticket_id = ticket_id
      @reason = reason
    end

    def add
      options = {
        action: "impersonate_user",
        user_type: History::AUDIT_LDAP_USER,
        user_id: @admin_id,
        resource_type: History::AUDIT_TWITCH_USER,
        resource_id: @user_id,
        changes: [
          History::ChangeSet.new(attribute: 'ip_address', new_value: @ip),
          History::ChangeSet.new(attribute: 'ticket_id', new_value: @ticket_id)
        ],
        description: @reason
      }
      audit = History::Audit.new(options)
      History::AddAudit.add(audit)
    end
  end
end
