module History
  class Report < GDPRBase
    attributes :user_id, :requester, :status, :request_time, :location

    def self.request_report(user_id, requester)
      resp = gdpr_client.request_report(
        user_id: user_id,
        requester: requester
      )
      raise resp.error if resp.error
      return resp
    end

    def self.list_reports(params)
      resp = gdpr_client.list_reports(
        requester: params[:requester]
      )
      raise resp.error if resp.error

      data_items = []
      unless resp.data.blank?
        data_items = resp.data.items
      end

      return {
        :items => data_items.map {|x| from_twirp_object(x)},
      }
    end
  end
end
