require 'history/constants'

module History
  class SessionAudit
    def initialize(admin_id:, user_id:, ip_address:)
      @admin_id = admin_id
      @user_id = user_id
      @ip = ip_address
    end

    def add
      options = {
        action: "session_created",
        user_type: History::AUDIT_LDAP_USER,
        user_id: @admin_id,
        resource_type: History::AUDIT_TWITCH_USER,
        resource_id: @user_id,
        description: "IP address #{@ip}",
      }
      audit = History::Audit.new(options)
      History::AddAudit.add(audit)
    end
  end
end
