module InternalWebApis
  class Base < Service::Base
    self.service_endpoint = Settings.twitch.internal.host

    def self.get_display_names(ids = [])
      id_string = ids.map(&:to_s).join(',')
      response = get "/api/internal/user/properties", params: {ids: id_string, properties: "display_name"}
      
      return {} unless response.success?

      response.body.inject({}) do |ret, info_map|
        ret[info_map["id"]] = info_map["login"]
        ret
      end
    end
  end
end
