module Keys
  class Base < Service::Base
    self.service_endpoint = Settings.phanto.endpoint

    def self.connection_options(options = {})
      options[:request] = :json
      return super(options)
    end

    def self.connection(options = {})
      super(options).tap do |c|
        c.response :json, :content_type => /\bjson$/
      end
    end
  end

  def self.ldap_header(ldap_login)
    { 'Twitch-LDAP-Login' => ldap_login }
  end
end
