module Keys
  class Batch < Keys::Base

    attributes :pool_id, :batch_id, :number_of_keys, :ldap_login

    # TODO: Refactor to use twirp generated client once custom headers are supported
    def self.all(pool_id, cursor, ldap_login)
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/GetKeyBatchesS2S',
        body: {
          :pool_id => pool_id,
          :cursor => cursor
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def create
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/GenerateKeyBatch',
        body: {
            :pool_id => self.pool_id,
            :batch_id => self.batch_id,
            :number_of_keys => self.number_of_keys
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def invalidate
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/InvalidateKeyBatch',
        body: {
            :batch_id => self.batch_id
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def update_status(new_status)
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/UpdateKeyBatch',
        body: {
            :batch_id => self.batch_id,
            :status => new_status
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

  end
end
