module Keys
  class Configuration < Keys::Base

    attributes :pool_id, :metadata_key, :metadata_value, :ldap_login

    # TODO: Refactor to use twirp generated client once custom headers are supported
    def self.all(pool_id, cursor, ldap_login)
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/GetKeyPoolMetadata',
        body: {
          :pool_id => pool_id,
          :cursor => cursor
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def create
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/CreateKeyPoolMetadata',
        body: {
          :pool_id => self.pool_id,
          :metadata_key => self.metadata_key,
          :metadata_value => self.metadata_value
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def delete
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/DeleteKeyPoolMetadata',
        body: {
          :pool_id => self.pool_id,
          :metadata_key => self.metadata_key
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

  end
end
