module Keys
  class HandlerGroup < Keys::Base

    attributes :handler_group_id, :description, :authorized_tuids_str, :authorized_tuids, :authorized_client_ids_str, :authorized_client_ids, :ldap_login

    def self.all(cursor, ldap_login)
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/GetKeyHandlerGroups',
        body: { :cursor => cursor }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def self.get(handler_group_id, ldap_login)
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/GetKeyHandlerGroup',
        body: {
          :handler_group_id => handler_group_id,
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def create
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/UpdateKeyHandlerGroup',
        body: {
          :handler_group_id => self.handler_group_id,
          :description => self.description,
          :authorized_tuids => self.authorized_tuids,
          :authorized_client_ids => self.authorized_client_ids
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

  end
end