module Keys
  class Product < Keys::Base

    attributes :product_type, :sku, :description, :ldap_login

    # TODO: Refactor to use twirp generated client once custom headers are supported
    def self.all(product_type, cursor, ldap_login)
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/GetProducts',
        body: { :product_type => product_type, :cursor => cursor }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def create
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/CreateProduct',
        body: {
            :product_type => self.product_type,
            :sku => self.sku,
            :description => self.description
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

  end
end
