module Keys
  class ProductType < Keys::Base

    attributes :product_type, :sns_topic, :description, :ldap_login

    # TODO: Refactor to use twirp generated client once custom headers are supported
    def self.all(cursor, ldap_login)
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/GetAllProductTypes',
        body: { :cursor => cursor }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

    def create
      post(
        '/twirp/code.justin.tv.commerce.phanto.Phanto/CreateProductType',
        body: {
            :product_type => self.product_type,
            :sns_topic => self.sns_topic,
            :description => self.description
        }.to_json,
        headers: Keys.ldap_header(ldap_login)
      )
    end

  end
end
