module Mako
  class Emote < Mako::Base
    attributes :id, :code, :suffix, :state, :group_id
    self.primary_attribute = :id

    def self.get_emoticons_by_emoticon_ids(emote_ids)
      response = client.get_emoticons_by_emoticon_ids(
        emoticon_ids: emote_ids
      )
      raise response.error.msg if response.error

      response.data.emoticons.map { |v| self.from_twirp_object(v) }
    end

    def self.get_global_emotes
      return Mako::Emote.get_emoticons_by_group("0")
    end

    def self.get_emoticons_by_group(group_id)
      response = client.get_emoticons_by_groups(
        emoticon_group_keys: [group_id]
      )
      raise response.error.msg if response.error
      if response.data.groups.empty? || response.data.groups[0].emoticons.empty?
        return []
      end

      response.data.groups[0].emoticons.map { |v| self.from_twirp_object(v) }
    end

    def self.deactivate_emoticon(emote_id)
      response = client.deactivate_emoticon(
        id: emote_id
      )
      raise response.error.msg if response.error
    end

    def self.update_emote_code_suffix(emote_id, code_suffix)
      response = client.update_emote_code_suffix(
        id: emote_id,
        code_suffix: code_suffix
      )
      raise response.error.msg if response.error
    end
  end
end
