module Mako
  class EmotePrefix < Mako::Base

    attributes :channel_id, :prefix, :state

    self.primary_attribute = :channel_id

    def self.get_pending_prefixes(limit)
      response = client.get_prefixes_by_state(
        state: "PREFIX_PENDING",
        limit: limit
      )
      raise response.error.msg if response.error

      response.data.prefix_entries.map { |v| self.from_twirp_object(v) }
    end

    def self.get_prefix(channel_id)
      response = client.get_prefix(
        channel_id: channel_id.to_s
      )
      raise response.error.msg if response.error

      self.from_twirp_object(response.data)
    end

    def self.set_prefix(channel_id, prefix, state)
      response = client.set_prefix(
        channel_id: channel_id,
        prefix: prefix,
        state: state
      )
      raise response.error.msg if response.error
    end
  end
end
