module Mulan
  class GetBalanceHistory < Mulan::Base
    attributes :date, :gross_amount_usd, :gross_amount, :currency, :product_type, :purchase_order_id

    def self.call(user_id)
      response = client.get_balance_history(
        user_id: user_id
      )

      raise response.error.msg if response.error

      response.data.balance_events.map { |v| self.from_twirp_object(v) }
    end
  end
end
