module Mulan
  class PurchaseProfileQuery < Mulan::Base
    QUERY_PURCHASE_PROFILE_ENDPOINT = '/twirp/code.justin.tv.revenue.mulan.Mulan/QueryPurchaseProfile'
    HEADERS = { 'Content-Type' => 'application/json' }

    # NOTE: Payments team is migrating all PurchaseProfile read calls to Mulan instead of Payments-Service
    def self.call(params = {})
      post QUERY_PURCHASE_PROFILE_ENDPOINT, { headers: HEADERS, body: format_params(params) }
    end

    def self.format_params(params)
      if params[:payment_provider].present?
        params[:payment_provider] = [params[:payment_provider]]
      end

      if params[:created_on_start].present?
        params[:created_on_start] = Date.parse(params[:created_on_start]).to_time.iso8601
      end

      if params[:created_on_end].present?
        params[:created_on_end] = Date.parse(params[:created_on_end]).to_time.iso8601
      end

      params.to_json
    end
  end
end
