module OauthClients
  class Authorization < OauthClients::Base
    self.primary_attribute = :uuid

    attributes :uuid, :owner_id, :client_id, :client_id_canonical

    def initialize(opts = {})
      opts.each do |k, v|
        if self.respond_to? k
          self.send("#{k}=", v)
        end
      end
    end

    def self.all(user_id)
      authorizations = []
      params = {owner_id: user_id}
      response = get "/authorizations", params: params

      return authorizations unless response.success?

      response.body['authorizations'].each do |authorization|
        authorizations << Authorization.new(authorization)
      end
      authorizations
    end

    def destroy
      response = delete "/authorizations?owner_id=#{self.owner_id}&client_id=#{self.client_id_canonical}"
      response.success?
    end
  end
end
