require 'jwt'

module Passport
  class Base < Service::Base

    attr_accessor :redirect_endpoint

    self.service_endpoint = Settings.passport.endpoint

    ERR_MFA_NOT_ENABLED = 'MFA not enabled for account'
    ERR_FROM_AUTHY = 'Error from Authy'
    ERR_FROM_PASSPORT = 'Error from Passport'
    ERR_TIMEOUT = 'lookup timed out'
    ERR_UNKNOWN = 'lookup failed'

    def self.passport_token(user_id)
      JWT.encode({
        iat: Time.now.to_i,
        exp: (Time.now + 5.minute).to_i,
        sub: user_id.to_s,
        aud: [:passport],
        iss: "https://www.twitch.tv"
      }, Settings.secrets.passport.jwt_secret, 'HS512')
    end

    def self.base_uri
      return URI.parse(Settings.passport.redirect_endpoint)
    end
  end
end
