require "bcrypt"

module Passport
  include BCrypt

  TRUSTED_COOKIE = "passport_trusted_request=true"

  class Passwords < Passport::Base
    def self.force_reset(user_id)
      body = {
          force_password_reset: true,
          token: passport_token(user_id)
      }
      headers = {
          Cookie: TRUSTED_COOKIE
      }

      response = put "/internal/user/#{user_id}/edit", body: body, headers: headers
      response.success?
    end

    def self.update_password(user_id, password)
      body = {
          password_hash: BCrypt::Password.create(password),
          token: passport_token(user_id)
      }
      headers = {
          Cookie: TRUSTED_COOKIE
      }
      response = put "/internal/user/#{user_id}/edit", body: body, headers: headers
      response.success?
    end
  end
end
