module Passport
  class UserImpersonation < Base
    attributes :user_id, :admin_id, :user_ip, :ticket_id, :reason

    def audit_impersonation
      History::ImpersonateUserAudit.new(
        admin_id: admin_id,
        user_id: user_id,
        ip_address: user_ip,
        ticket_id: ticket_id,
        reason: reason
      ).add
    end

    # Generate a URL that allows impersonation of a user.
    def url
      URI::HTTPS.build(
        host: self.class.base_uri.host,
        path: "/api/v1/impersonation/#{user_id}",
        query: {
          token: self.class.passport_token(user_id)
        }.to_query
      ).to_s
    end
  end
end
