module Payments
  class BalanceHistory < Payments::Base
    attributes :date,
               :product_type,
               :purchase_order_id,
               :gross_amount_usd

    def self.find_by_user(user_id)
      return if user_id.blank?
      response = Mulan::GetBalanceHistory.call(user_id: user_id)
      raise response.error.msg if response.error

      if response.data['balance_events']
        res = response.data['balance_events'].map do |balance_event|
          from_attributes(balance_event)
        end
        # Set a high page number since we don't know the total count
        paginate res, total_pages: 100
      else
        empty_response
      end
    end
  end
end
