module Payments
  class RefundAllPayments < Payments::Base

    AUDIT_ACTION_UPDATE = "create"
    AUDIT_MASS_REFUND = "mass_refund"
    AUDIT_LDAP_USER = "ldap_user"

    # rubocop:disable ParameterLists
    def self.refund_all_payments(user_id, admin_ldap_login, admin_email, num_days_to_refund, reason, created_at_start = nil, created_at_end = nil, product_types = nil)
      # rubocop:enable ParameterLists
      response = post '/admin/refund', body: {
        user_id: user_id.to_s,
        admin_id: admin_ldap_login,
        admin_email: admin_email,
        num_days_to_refund: num_days_to_refund,
        reason: reason,
        created_at_start: created_at_start,
        created_at_end: created_at_end,
        product_types: product_types
      }

      audit_params = {
          user_id: user_id.to_s,
          num_days_to_refund: num_days_to_refund,
          reason: reason,
          created_at_start: created_at_start,
          created_at_end: created_at_end,
          product_types: product_types
      }

      response.success? && audit_mass_refund(admin_ldap_login, audit_params)
    end

    def self.audit_mass_refund(admin_login, params)
      changes = []

      params.each do |key, val|
        change = History::ChangeSet.new(
          attribute: key,
          new_value: val
        )
        changes.push(change)
      end

      audit = History::Audit.new(
        action: AUDIT_ACTION_UPDATE,
        user_type: AUDIT_LDAP_USER,
        user_id: admin_login,
        resource_type: AUDIT_MASS_REFUND,
        changes: changes
      )

      History::AddAudit.add(audit)
    end
  end
end
