module Payments
  class RefundPreview < Payments::Base

    # rubocop:disable ParameterLists
    def self.refund_preview(user_id, admin_ldap_login, admin_email, num_days_to_refund, created_at_start = nil, created_at_end = nil, product_types = nil)
      # rubocop:enable ParameterLists
      get '/admin/refund_preview', params: {
        user_id: user_id.to_s,
        admin_id: admin_ldap_login,
        admin_email: admin_email,
        num_days_to_refund: num_days_to_refund,
        created_at_start: created_at_start,
        created_at_end: created_at_end,
        product_types: product_types
      }
    end
  end
end
