module Payments
  class SyncTicketProduct < Payments::Base

    def self.do(id)
      ticket_product = Subscriptions::TicketProduct.find(id)
      params = {
        short_name: ticket_product.short_name,
        ext_product_id: ticket_product.ext_product_id,
        ext_product_name: ticket_product.ext_product_name,
        ext_product_description: ticket_product.ext_product_description,
        interval_unit: ticket_product.interval_unit,
        interval_number: ticket_product.interval_number,
        default_price: ticket_product.price_in_cents
      }
      response = put "/products/#{id}/sync_external_products", body: params
      response.success?
    end
  end
end
