module Payments
  class Ticket < Payments::Base
    # Payments service currently has a GET /purchase_profile/:id/ticket API
    self.primary_attribute = :id

    attributes :id,
               :ticket_product_id,
               :owner_id,
               :access_start,
               :access_end,
               :is_renewable,
               :is_set_to_renew,
               :notes

    def owner
      @owner ||= Twitch::User.find(owner_id)
    end

    def access_start
      DateTime.parse(@access_start) rescue nil
    end

    def access_end
      DateTime.parse(@access_end) rescue nil
    end
  end
end
