module Payments
  class XsollaPlan < Payments::Base
    self.primary_attribute = :id

    attributes :id, :group_id, :plan_id, :price, :month_interval

    def self.load_plans
      response = get "/xsolla_plans"

      if response.success?
        response.body['xsolla_plans'].map do |xsolla_plan|
          from_attributes(xsolla_plan)
        end
      else
        empty_response
      end
    end

    def save
      return false unless valid?

      response = post "/xsolla_plans.json", body: as_json

      self.errors = response.body["errors"] unless response.success?

      response.success?
    end
  end
end
