module PayoutEntities
  class Attribution < PayoutEntities::Base
    attributes :payout_entity_id,
      :login,
      :start_date

    self.primary_attribute = :payout_entity_id

    def self.remove_attribution(payout_entity_id, channel_id, options)
      response = delete "/payout/entity/#{payout_entity_id}/attributions/#{channel_id}", headers: ldap_headers(options)
    end

    def self.add_attribution(payout_entity_id, channel_id, start_date, options)
      response = post "/payout/entity/#{payout_entity_id}/attributions/#{channel_id}", body: {start_date: start_date.to_datetime}.to_json, headers: ldap_headers(options)
    end
  end
end
